clear all;
close all;

A = importdata('Field_Tc_50.txt');
Data = A.data;
H = Data(:,1);
Tc = Data(:,2);

figure;
hold on;
box on;
scatter(Data(:,2),Data(:,1),'x','b','linewidth',1.5);
set(gca,'fontsize',15,'fontname','times');
set(gcf,'color','w');
xlabel('T = Tc(50%) (K)','fontsize',20,'fontname','times');
ylabel('Field (T)','fontsize',20,'fontname','times');
xlim([0 5.5]);
ylim([0 12]);